/*
TWO VERY IMPORTANT FEATURES OF ES9
1. finally
2. for await

----> SWAPI - star wars api for fetching data 
about people, ships, planets...
url :https://swapi.dev/

----> JSONPlaceholder
Fake Online REST API for Testing and Prototyping 
url: https://jsonplaceholder.typicode.com/
*/

const starShipsUrls = [
    'https://swapi.dev/api/starships/3/',
    'https://swapi.dev/api/starships/5/',
    'https://swapi.dev/api/starships/9/',
    'https://swapi.dev/api/starships/10/',
    'https://swapi.dev/api/starships/12/',
    'https://swapi.dev/api/starships/15/'
];

Promise.all(starShipsUrls.map(url =>{
    return fetch(url).then(ships => ships.json())
}))
.then(array =>{
   
    console.log('1',array[0]);
    console.log('2',array[1]);
    console.log('3',array[2]);
    console.log('4',array[3]);
    console.log('5',array[4]);
    console.log('6',array[5]);
})
.catch(err => console.log('Ohhh there was some kind of an error, what it could be?'))
.finally(() =>console.log('finally I want to print something'));


// for await

const JSONPlaceholderUrls = [
    'https://jsonplaceholder.typicode.com/users',
    'https://jsonplaceholder.typicode.com/posts',
    'https://jsonplaceholder.typicode.com/albums'
];

const getResults = async function(){

    const arrayOfPromises = JSONPlaceholderUrls.map(url =>fetch(url));
    for await(let request of arrayOfPromises){
        const data = await request.json();
        console.log(data);
    }
};
getResults();